#ifndef  IOREGS12_H
#define  IOREGS12_H

#ifndef  IOREGS_BASE
#define  IOREGS_BASE    0x0000
#endif

#define _IO8(off)       *(volatile unsigned char *)(IOREGS_BASE + off)
#define _IO16(off)      *(volatile unsigned short *)(IOREGS_BASE + off)

#define  PORTA      _IO8(0x00)      /* i/o port a */
#define  PORTB      _IO8(0x01)      /* i/o port b */
#define  DDRA       _IO8(0x02)      /* data direction reg a */
#define  DDRB       _IO8(0x03)      /* data direction reg b */
#define  PORTE      _IO8(0x08)      /* i/o port e */
#define  DDRE       _IO8(0x09)      /* data direction reg e */
#define  PEAR       _IO8(0x0a)      /* pear */
#define  MODE       _IO8(0x0b)      /* mode */
#define  PUCR       _IO8(0x0c)      /* pucr */
#define  RDRIV      _IO8(0x0d)      /* rdriv */
#define  EBICTL	    _IO8(0x0e)      /* e stretch control */

#define  INITRM     _IO8(0x10)      /* initrm */
#define  INITRG     _IO8(0x11)      /* initrg */
#define  INITEE     _IO8(0x12)      /* initee */
#define  MISC       _IO8(0x13)      /* misc */
#define  MTST0      _IO8(0x14)      /* mtst0 */
#define  ITCR       _IO8(0x15)      /* itcr */
#define  ITEST      _IO8(0x16)      /* itest */
#define  MTST1      _IO8(0x17)      /* mtst1 */

#define  PARTIDH    _IO8(0x1a)      /* partidh */
#define  PARTIDL    _IO8(0x1b)      /* partidl */
#define  MEMSIZ0    _IO8(0x1c)      /* memsiz0 */
#define  MEMSIZ1    _IO8(0x1d)      /* memsiz1 */

#define  INTCR      _IO8(0x1e)      /* intcr */
#define  HPRIO      _IO8(0x1f)      /* hprio */

#define  BKPCT0     _IO8(0x28)
#define  BKPCT1     _IO8(0x29)
#define  BKP0X      _IO8(0x2a)
#define  BKP0H      _IO8(0x2b)
#define  BRP0l      _IO8(0x2c)
#define  BKP1X      _IO8(0x2d)
#define  BKP1H      _IO8(0x2e)
#define  BRP1L      _IO8(0x2f)

#define  PPAGE      _IO8(0x30)
#define  PORTK      _IO8(0x32)
#define  DDRK       _IO8(0x33)
#define  SYNR       _IO8(0x34)
#define  REFDV      _IO8(0x35)
#define  CTFLG      _IO8(0x36)
#define  CRGFLG     _IO8(0x37)
#define  CRGINT     _IO8(0x38)
#define  CLKSEL     _IO8(0x39)
#define  PLLCTL     _IO8(0x3a)
#define  RTICTL     _IO8(0x3b)
#define  COPCTL     _IO8(0x3c)
#define  FORBYP     _IO8(0x3d)
#define  CTCTL      _IO8(0x3e)
#define  ARMCOP     _IO8(0x3f)

#define  TIOS       _IO8(0x40)
#define  CFORC      _IO8(0x41)
#define  OC7M       _IO8(0x42)
#define  OC7D       _IO8(0x43)
#define  TCNT       _IO16(0x44)
#define  TSCR       _IO8(0x46)
#define  TTOV       _IO8(0x47)
#define  TCTL1      _IO8(0x48)
#define  TCTL2      _IO8(0x49)
#define  TCTL3      _IO8(0x4a)
#define  TCTL4      _IO8(0x4b)
#define  TMSK1      _IO8(0x4c)
#define  TMSK2      _IO8(0x4d)
#define  TFLG1      _IO8(0x4e)
#define  TFLG2      _IO8(0x4f)

#define  TC0        _IO16(0x50)
#define  TC1        _IO16(0x52)
#define  TC2        _IO16(0x54)
#define  TC3        _IO16(0x56)
#define  TC4        _IO16(0x58)
#define  TC5        _IO16(0x5a)
#define  TC6        _IO16(0x5c)
#define  TC7        _IO16(0x5e)

#define  PACTL      _IO8(0x60)
#define  PAFLG      _IO8(0x61)
#define  PACN3      _IO8(0x62)
#define  PACN2      _IO8(0x63)
#define  PACN1      _IO8(0x64)
#define  PACN0      _IO8(0x65)
#define  MCCTL      _IO8(0x66)
#define  MCFLG      _IO8(0x67)
#define  ICPAR      _IO8(0x68)
#define  DLYCT      _IO8(0x69)
#define  ICOVW      _IO8(0x6a)
#define  ICSYS      _IO8(0x6b)
#define  TIMTST     _IO8(0x6d)

#define  ATD0CTL0   _IO8(0x80)
#define  ATD0CTL1   _IO8(0x81)
#define  ATD0CTL2   _IO8(0x82)
#define  ATD0CTL3   _IO8(0x83)
#define  ATD0CTL4   _IO8(0x84)
#define  ATD0CTL5   _IO8(0x85)
#define  ATD0STAT   _IO16(0x86)

#define  ATD0DIEN	_IO8(0x8d)

#define  PORTAD     _IO8(0x8f)
#define  ADR00H     _IO8(0x90)
#define  ADR01H     _IO8(0x92)
#define  ADR02H     _IO8(0x94)
#define  ADR03H     _IO8(0x96)
#define  ADR04H     _IO8(0x98)
#define  ADR05H     _IO8(0x9a)
#define  ADR06H     _IO8(0x9c)
#define  ADR07H     _IO8(0x9e)

#define  PWME		_IO8(0xa0)
#define  PWMPOL     _IO8(0xa1)
#define  PWMCLK     _IO8(0xa2)
#define  PWMPRCLK   _IO8(0xa3)
#define  PWMCAE     _IO8(0xa4)
#define  PWMCTL     _IO8(0xa5)
#define  PWMSCLA    _IO8(0xa8)
#define  PWMSCLB    _IO8(0xa9)
#define  PWMCNT0    _IO8(0xac)
#define  PWMCNT1    _IO8(0xad)
#define  PWMCNT2    _IO8(0xae)
#define  PWMCNT3    _IO8(0xaf)
#define  PWMCNT4    _IO8(0xb0)
#define  PWMCNT5    _IO8(0xb1)
#define  PWMCNT6    _IO8(0xb2)
#define  PWMCNT7    _IO8(0xb3)
#define  PWMPER0    _IO8(0xb4)
#define  PWMPER1    _IO8(0xb5)
#define  PWMPER2    _IO8(0xb6)
#define  PWMPER3    _IO8(0xb7)
#define  PWMPER4    _IO8(0xb8)
#define  PWMPER5    _IO8(0xb9)
#define  PWMPER6    _IO8(0xba)
#define  PWMPER7    _IO8(0xbb)
#define  PWMDTY0    _IO8(0xbc)
#define  PWMDTY1    _IO8(0xbd)
#define  PWMDTY2    _IO8(0xbe)
#define  PWMDTY3    _IO8(0xbf)
#define  PWMDTY4    _IO8(0xc0)
#define  PWMDTY5    _IO8(0xc1)
#define  PWMDTY6    _IO8(0xc2)
#define  PWMDTY7    _IO8(0xc3)
#define  PWMSDN     _IO8(0xc4)

#define  SC0BDH     _IO8(0xc8)
#define  SC0BDL     _IO8(0xc9)
#define  SC0CR1     _IO8(0xca)
#define  SC0CR2     _IO8(0xcb)
#define  SC0SR1     _IO8(0xcc)
#define  SC0SR2     _IO8(0xcd)
#define  SC0DRH     _IO8(0xce)
#define  SC0DRL     _IO8(0xcf)
#define  SC1BDH     _IO8(0xd0)
#define  SC1BDL     _IO8(0xd1)
#define  SC1CR1     _IO8(0xd2)
#define  SC1CR2     _IO8(0xd3)
#define  SC1SR1     _IO8(0xd4)
#define  SC1SR2     _IO8(0xd5)
#define  SC1DRH     _IO8(0xd6)
#define  SC1DRL     _IO8(0xd7)
#define  SPI0CR1    _IO8(0xd8)
#define  SPI0CR2    _IO8(0xd9)
#define  SPI0BR     _IO8(0xda)
#define  SPI0SR     _IO8(0xdb)
#define  SP0DR      _IO8(0xdd)

#define PTT _IO8(0x240)
#define PTIT	_IO8(0x241)
#define DDRT	_IO8(0x242)
#define RDRT	_IO8(0x243)
#define PERT	_IO8(0x244)
#define PPST	_IO8(0x245)
#define PTS	_IO8(0x248)
#define PTIS	_IO8(0x249)
#define DDRS	_IO8(0x24a)
#define RDRS	_IO8(0x24b)
#define PERS	_IO8(0x24c)
#define PPSS	_IO8(0x24d)
#define WOMS	_IO8(0x24e)
#define PTM	_IO8(0x250)
#define PTIM	_IO8(0x251)
#define DDRM	_IO8(0x252)
#define RDRM	_IO8(0x253)
#define PERM	_IO8(0x254)
#define PPSM	_IO8(0x255)
#define WOMM	_IO8(0x256)
#define MODRR	_IO8(0x257)
#define PTP	_IO8(0x258)
#define PTIP	_IO8(0x259)
#define DDRP	_IO8(0x25a)
#define RDRP	_IO8(0x25b)
#define PERP	_IO8(0x25c)
#define PPSP	_IO8(0x25d)
#define PIEP	_IO8(0x25e)
#define PIFP	_IO8(0x25f)
#define PTH	_IO8(0x260)
#define PTIH	_IO8(0x261)
#define DDRH	_IO8(0x262)
#define RDRH	_IO8(0x263)
#define PERH	_IO8(0x264)
#define PPSH	_IO8(0x265)
#define PIEH	_IO8(0x266)
#define PIFH	_IO8(0x267)
#define PTJ	_IO8(0x268)
#define PTIJ	_IO8(0x269)
#define DDRJ	_IO8(0x26a)
#define RDRJ	_IO8(0x26b)
#define PERJ	_IO8(0x26c)
#define PPSJ	_IO8(0x26d)
#define PIEJ	_IO8(0x26e)
#define PIFJ	_IO8(0x26f)

#endif
