/* M68HCS12C32 Interrupt vectors table */

	.sect .text
	.globl _start

;; Default interrupt handler.
	.sect .text
def:
	rti

;; 
;; Interrupt vectors are in a specific section that is
;; mapped at 0xff8a. For the example program, the reset handler
;; points to the generic crt0 entry point.
;;
	.sect .vectors
	.globl vectors
vectors:
   	.word def			; ff8a (VREG LVI)
	.word def			; ff8c (PWM Emergency  Shutdown)
	.word def			; ff8e (PORT P)
	.word def			; ff90
	.word def			; ff92
	.word def			; ff94
   	.word def			; ff96
	.word def			; ff98
	.word def			; ff9a
	.word def			; ff9c
	.word def			; ff9e
   	.word def			; ffa0
	.word def			; ffa2
	.word def			; ffa4
	.word def			; ffa6
	.word def			; ffa8
	.word def			; ffaa
   	.word def			; ffac
	.word def			; ff9e
	.word def			; ffb0 (CAN transmit)
	.word def			; ffb2 (CAN receive)
	.word def			; ffb4 (CAN errors)
	.word def			; ffb6 (CAN wake-up)
	.word def			; ffb8 (FLASH)
	.word def			; ffba
	.word def			; ffbc
	.word def			; ffbe
	.word def			; ffc0
	.word def			; ffc2
	.word def			; ffc4 (CRG SELF CLOCK MODE)
	.word def			; ffc6 (CRG PLL LOCK)
	.word def			; ffc8
	.word def			; ffca
	.word def			; ffcc
	.word def			; ffce (PortJ)
	.word def			; ffd0
	.word def			; ffd2 (ATD)
	.word def			; ffd4

	.word def			; ffd6 (SCI)
	.word def			; ffd8 (SPI)
	.word def			; ffda (Pulse accumulator input edge)
	.word def			; ffdc (Pulse accumulator A overflow)
	.word def			; ffde (Standard Timer Overflow)

	;; Timer Channel
	.word def			; ffe0 (Standard Timer channel_7)
	.word def			; ffe2 (Standard Timer channel_6)
	.word def			; ffe4 (Standard Timer channel_5)
	.word def        		; ffe6 (Standard Timer channel_4)
	.word TC3Handle   		; ffe8 (Standard Timer channel_3)
	.word def           		; ffea (Standard Timer channel_2)
	.word def           		; ffec (Standard Timer channel_1)
	.word def           		; ffee (Standard Timer channel_0)

	;;  Misc
	.word RTIHandle    		; fff0 (Real Time Interrupt)
	.word def			; fff2 (IRQ)
	.word def			; fff4 (XIRQ)
	.word def   			; fff6 (SWI)
	.word def			; fff8 (Unimplemented instruction trap)
	.word def    			; fffa (COP Failure reset)
	.word def			; fffc (Clock monitor fail reset)
	.word _start			; fffe (reset)

